/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config;

import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.misc.BackpackSize;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

@Config(modid="wearablebackpacks")
public class ModConfig {
    @Config.Comment(value={"Server Config"})
    @Config.Name(value="Server")
    public static final ServerConfig server = new ServerConfig();
    @Config.Comment(value={"Client Config"})
    @Config.Name(value="Client")
    public static final ClientConfig client = new ClientConfig();

    @Mod.EventBusSubscriber(modid="wearablebackpacks")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("wearablebackpacks")) {
                server.resetCache();
                ConfigManager.sync((String)"wearablebackpacks", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ClientConfig {
        @Config.Comment(value={"Controls the opacity / visibility of the enchantment effect on equipped and placed backpacks, if present. Default: 80%."})
        @Config.Name(value="Enchant Effect Opacity")
        @Config.LangKey(value="config.wearablebackpacks.cosmetic.enchantEffectOpacity")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double enchantEffectOpacity = 0.8;
    }

    public static class ServerConfig {
        private BackpackSize backpackSize;
        private Potion backpackEffect;
        @Config.Comment(value={"Whether or not the backpack should be equipped as a Bauble."})
        @Config.Name(value="Equip Backpack as Bauble")
        @Config.LangKey(value="config.wearablebackpacks.server.equipAsBauble")
        public boolean equipAsBauble = true;
        @Config.Comment(value={"If enabled, allows equipped backpacks to be opened by other players by right clicking the target's back."})
        @Config.Name(value="Enable Equipped Interaction")
        @Config.LangKey(value="config.wearablebackpacks.general.enableEquippedInteraction")
        public boolean enableEquippedInteraction = true;
        @Config.Comment(value={"If enabled, allows players to open their own equipped backpack without requiring it to be placed first using a keybind."})
        @Config.Name(value="Enable Self Interaction")
        @Config.LangKey(value="config.wearablebackpacks.general.enableSelfInteraction")
        public boolean enableSelfInteraction = false;
        @Config.Comment(value={"If enabled, allows machines to interact with placed backpacks."})
        @Config.Name(value="Enable Machine Interaction")
        @Config.LangKey(value="config.wearablebackpacks.general.enableMachineInteraction")
        public boolean enableMachineInteraction = false;
        @Config.Comment(value={"If enabled, places equipped backpacks as a block on death, instead of scattering the items all around."})
        @Config.Name(value="Drop as Block on Death")
        @Config.LangKey(value="config.wearablebackpacks.general.dropAsBlockOnDeath")
        public boolean dropAsBlockOnDeath = true;
        @Config.Comment(value={"Should backpack placement and breaking attempt to ignore event cancellation? (Patches Lycanite's boss arena voiding backpacks)"})
        @Config.Name(value="Backpack Ignore Cancellation")
        @Config.LangKey(value="config.wearablebackpacks.general.ignoreCancellation")
        public boolean ignoreCancellation = false;
        @Config.Comment(value={"Column size of a normal backpack. Does not affect placed or equipped backpacks until turned back into an item."})
        @Config.Name(value="Backpack Size Column")
        @Config.LangKey(value="config.wearablebackpacks.size.sizeColumn")
        @Config.RangeInt(min=1, max=17)
        public int backpackSizeColumn = 9;
        @Config.Comment(value={"Row size of a normal backpack. Does not affect placed or equipped backpacks until turned back into an item."})
        @Config.Name(value="Backpack Size Row")
        @Config.LangKey(value="config.wearablebackpacks.size.sizeRow")
        @Config.RangeInt(min=1, max=6)
        public int backpackSizeRow = 4;
        @Config.Comment(value={"Controls whether mobs spawned naturally can randomly be wearing backpacks."})
        @Config.Name(value="Natural Mobs Spawn With Backpacks")
        @Config.LangKey(value="config.wearablebackpacks.entity.spawnNaturally")
        public boolean spawnNaturally = true;
        @Config.Comment(value={"Controls whether mobs spawned from spawners can randomly be wearing backpacks."})
        @Config.Name(value="Spawned Mobs Spawn With Backpacks")
        @Config.LangKey(value="config.wearablebackpacks.entity.spawnFromSpawners")
        public boolean spawnFromSpawners = false;
        @Config.Comment(value={"Whether or not to apply a potion effect to the player while wearing a backpack."})
        @Config.Name(value="Apply Potion Effect")
        @Config.LangKey(value="config.wearablebackpacks.effect.doEffect")
        public boolean doPotionEffect = false;
        @Config.Comment(value={"Amplifier of the potion effect to be applied to the player while wearing a backpack."})
        @Config.Name(value="Potion Effect Amplifier")
        @Config.LangKey(value="config.wearablebackpacks.effect.effectAmplifier")
        @Config.RangeInt(min=0, max=10)
        public int potionEffectAmplifier = 0;
        @Config.Comment(value={"The Resourcelocation of the potion effect to be applied on the player while wearing a backpack. (Ex. minecraft:weakness)"})
        @Config.Name(value="Potion Effect Name")
        @Config.LangKey(value="config.wearablebackpacks.effect.effectName")
        public String potionEffectName = "";

        public void resetCache() {
            this.backpackSize = null;
            this.backpackEffect = null;
        }

        public BackpackSize getBackpackSize() {
            if (this.backpackSize == null) {
                this.backpackSize = new BackpackSize(this.backpackSizeColumn, this.backpackSizeRow);
            }
            return this.backpackSize;
        }

        public Potion getBackpackEffect() {
            if (this.backpackEffect == null) {
                this.backpackEffect = Potion.func_180142_b((String)this.potionEffectName);
                if (this.backpackEffect == null) {
                    WearableBackpacks.LOG.log(Level.WARN, "WearableBackpacksRLCraft: Invalid potion effect in config, returning weakness.");
                    this.backpackEffect = MobEffects.field_76437_t;
                }
            }
            return this.backpackEffect;
        }
    }
}

